// *************************************************************************************************
// PURPOSE:
// List all web content items missing their display page
// *************************************************************************************************
// USAGE:
//    1. Edit the structureId and groupId to filter the articles
//    2. Run the script
// *************************************************************************************************

def structureId = "NEWS"
def groupId = 381376
def defaultDisplayLayoutUuid = "ec10ee1a-3423-4aa0-b96a-df0272321e32";

import com.liferay.portal.kernel.workflow.WorkflowConstants
import com.liferay.portal.service.GroupLocalServiceUtil
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil
import com.liferay.portlet.journal.asset.JournalArticleAssetRenderer
import com.liferay.portlet.journal.model.JournalArticle
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil
import com.liferay.portal.service.LayoutLocalServiceUtil
import java.util.Locale
import com.liferay.portal.kernel.util.MathUtil
import com.liferay.portal.service.ServiceContext
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil

import com.liferay.portal.kernel.log.LogFactoryUtil

def locale = new Locale("en", "AU")
def log = LogFactoryUtil.getLog("script")

def logLine =  "Start"
log.info logLine
out.println logLine

for (article in JournalArticleLocalServiceUtil.getArticles(groupId)) {
	if (article != null && article.status == WorkflowConstants.STATUS_APPROVED &&
			JournalArticleLocalServiceUtil.isLatestVersion(article.groupId, article.articleId, article.version, article.status) &&
			article.structureId == structureId) {
			
		
		
		if (!article.layoutUuid?.trim()) {

		   article.setLayoutUuid(defaultDisplayLayoutUuid)
                   def currentArticleVersion =article.getVersion()
                   def newArticleVersion = MathUtil.format(currentArticleVersion + 0.1, 1, 1);
                   //article.setVersion(newArticleVersion)
                   logLine = "Changing display page to 'General News' for ${article.getUuid()}, ${article.getTitle(locale)} , currentVersion:${article.getVersion()}  "

                   log.info logLine
                   out.println logLine

		   //JournalArticleLocalServiceUtil.updateJournalArticle(article);
		   ServiceContext serviceContext = new ServiceContext();

                   long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds(
			JournalArticle.class.getName(), article.getResourcePrimKey())
                   serviceContext.setAssetCategoryIds(assetCategoryIds)

                   String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames(
			JournalArticle.class.getName(), article.getResourcePrimKey())
                   serviceContext.setAssetTagNames(assetTagNames)

                   serviceContext.setScopeGroupId(article.getGroupId())
                   serviceContext.setCompanyId(article.getCompanyId())
                   serviceContext.setUserId(article.getUserId())

                   //JournalArticle newArticle = JournalArticleLocalServiceUtil.updateArticle(article.getUserId(),article.getGroupId(),
                   //    article.getFolderId(),article.getArticleId(),article.getVersion(),
                   //    article.getTitleMap(), article.getDescriptionMap(), article.getContent(),
                   //   defaultDisplayLayoutUuid, serviceContext);
                   //logLine = "UPDATE ARTICLE: new version created: ${newArticle.getUuid()}, ${newArticle.getLayoutUuid()}, ${newArticle.getTitle(locale)}, ${newArticle.getVersion()} "
                   //log.info logLine
                   //out.println logLine 
		}
	}
}

logLine = "DONE"
log.info logLine
out.println logLine